using System;
using Server;
using Server.Items;
using Server.Network;
using Server.Mobiles;

namespace Server.Engines.XmlSpawner2
{
	public class XmlDesc : XmlAttachment
	{
		private string m_DataValue;
		private bool m_IsTemp = false;

		[CommandProperty( AccessLevel.GameMaster )]
		public string Description { get{ return m_DataValue; } set { m_DataValue = value; } }

		// These are the various ways in which the message attachment can be constructed.  
		// These can be called via the [addatt interface, via scripts, via the spawner ATTACH keyword.
		// Other overloads could be defined to handle other types of arguments
       
		// a serial constructor is REQUIRED
		public XmlDesc(ASerial serial) : base(serial)
		{
		}

		[Attachable]
		public XmlDesc(string value)
		{
			Name = "Description";
			Description = value;
		}
        
		[Attachable]
		public XmlDesc(string value, double expiresin)
		{
			Name = "Description";
			Description = value;
			Expiration = TimeSpan.FromMinutes(expiresin);
         
         if( Expiration > TimeSpan.Zero )
            m_IsTemp = true;
		}

		[Attachable]
		public XmlDesc(string name, string value, double expiresin)
		{
			Name = name;
			Description = value;
			Expiration = TimeSpan.FromMinutes(expiresin);
			
         if( Expiration > TimeSpan.Zero )
            m_IsTemp = true;
		}
		
		public override void OnDelete()
		{
			base.OnDelete();

			if( AttachedTo is Item && m_IsTemp )
			{
				((Item)AttachedTo).Delete();
			}
		}

		public override void OnAttach()
		{
			base.OnAttach();
		    
			if( AttachedTo is Mobile )
			{
				// dont allow mobile attachments
				Delete();
			}
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize(writer);

			writer.Write( (int) 0 );
			// version 0
			writer.Write(m_DataValue);

		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
			// version 0
			m_DataValue = reader.ReadString();
			
         if( Expiration > TimeSpan.Zero )
            m_IsTemp = true;
		}

		public override string OnIdentify(Mobile from)
		{
			if( Description == null || Description.Length < 1 ) return null;

			if( Expiration > TimeSpan.Zero )
			{
				return String.Format("{0}\nZivotnost: {1}",Description, FormatTime(Expiration));
			} 
			else
			{
				return String.Format("{0}", Description);
			}
		}

        public static string FormatTime(TimeSpan Expiration)
        {
            if (Expiration == TimeSpan.Zero)
                return "";

            if (Expiration.TotalDays > 1.0)
                return String.Format("{0}dni {1}hod {2}min", Expiration.Days, Expiration.Hours, Expiration.Minutes);
            else if (Expiration.TotalHours > 1.0)
                return String.Format("{0}hod {1}min {2}sec", Expiration.Hours, Expiration.Minutes, Expiration.Seconds);
            else
                return String.Format("{0}min {1}sec", Expiration.Minutes, Expiration.Seconds);
        }
    }
}
